@extends('backoffice.dashboard')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<style>
.block-card { border-radius:8px; box-shadow:0 6px 18px rgba(0,0,0,0.05); }
.block-card-header { padding:18px; border-bottom:1px solid #eee; }
.block-card-body { padding:18px; }
.badge-available { background:#198754; color:#fff; padding:.4rem .7rem; border-radius:6px; }
.badge-occupied  { background:#dc3545; color:#fff; padding:.4rem .7rem; border-radius:6px; }
.lit-box { border:1px solid #eee; border-radius:8px; padding:12px; }
.small-muted { color:#6c757d; font-size:.9rem; }
.dir-rtl { direction: rtl; text-align: right; }
.btn-toggle { min-width:100px; }
.input-date { width:160px; display:inline-block; margin-left:8px; }
</style>

<div class="container dir-rtl mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="block-card mb-3">
                <div class="block-card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="widget-title mb-0">الغرفة: <strong class="text-danger">{{ $chambre->num_chambre }}</strong></h3>
                        <div class="small-muted">الطاقة الإستيعابية: <strong>{{ $chambre->capacite }}</strong> سرير</div>
                    </div>
                </div>

                <div class="block-card-body">
                    <div class="mb-3 d-flex align-items-center justify-content-between">
                        <div class="dir-rtl">
                            <label class="small-muted mb-0">التاريخ:</label>
                            <input type="date" id="dispoDate" class="form-control input-date"
                                   value="{{ $date ?? \Carbon\Carbon::today()->toDateString() }}">
                            <button id="refreshDateBtn" class="btn bg-rgb-primary1 font-weight-medium" style="margin-right:8px;">
                                عرض
                            </button>
                            <small class="small-muted d-block mt-1">اختر التاريخ لعرض/تعديل التوافر (افتراضي: اليوم)</small>
                        </div>

                        <div class="text-start">
                            @php
                                $totalHomme = 0; $totalFemme = 0;
                                foreach($lits as $p) {
                                    if(!empty($p['homme'])) $totalHomme++;
                                    if(!empty($p['femme'])) $totalFemme++;
                                }
                                $litsDisponiblesCount = 0;
                                foreach($lits as $p) if(!empty($p['homme']) || !empty($p['femme'])) $litsDisponiblesCount++;
                            @endphp
                            <div class="mb-1"><small class="small-muted">مشغول (رجال)</small> <strong>{{ $totalHomme }}</strong></div>
                            <div class="mb-1"><small class="small-muted">مشغول (نساء)</small> <strong>{{ $totalFemme }}</strong></div>
                            <div><small class="small-muted">الأسرّة المتاحة</small> <strong>{{ $litsDisponiblesCount }}/{{ $chambre->capacite }}</strong></div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <button id="blockRoomBtn" class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-lock mr-1"></i> غلق/فتح كل الأسرة
                        </button>
                        <small class="small-muted d-block mt-1">اضغط هنا لجعل الغرفة غير قابلة للتعيين (قفل) أو إعادتها متاحة.</small>
                    </div>

                    <div class="row g-3">
                        @foreach($lits as $num => $pair)
                            @php
                                $isH = $pair['homme'] ?? false;
                                $isF = $pair['femme'] ?? false;
                            @endphp
                            <div class="col-md-6">
                                <div class="lit-box">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <div>
                                            <h6 class="mb-0">السرير رقم {{ $num }}</h6>
                                            <div class="small-muted">الحالة حسب الجنس</div>
                                        </div>
                                        <div>
                                            @if($isH || $isF)
                                                <span class="badge-available">متاح</span>
                                            @else
                                                <span class="badge-occupied">مشغول</span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-6">
                                            <div class="mb-2">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <strong>رجال</strong>
                                                        <div class="small-muted">حالة</div>
                                                    </div>
                                                    <div>
                                                        <button class="btn btn-sm btn-toggle {{ $isH ? 'btn-outline-success' : 'btn-outline-danger' }} js-toggle"
                                                                data-chambre="{{ $chambre->id_chambre_tente }}"
                                                                data-lit="{{ $num }}"
                                                                data-sexe="homme"
                                                                data-estado="{{ $isH ? 1 : 0 }}">
                                                            {{ $isH ? 'متاح' : 'مشغول' }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-6">
                                            <div class="mb-2">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <strong>نساء</strong>
                                                        <div class="small-muted">حالة</div>
                                                    </div>
                                                    <div>
                                                        <button class="btn btn-sm btn-toggle {{ $isF ? 'btn-outline-success' : 'btn-outline-danger' }} js-toggle"
                                                                data-chambre="{{ $chambre->id_chambre_tente }}"
                                                                data-lit="{{ $num }}"
                                                                data-sexe="femme"
                                                                data-estado="{{ $isF ? 1 : 0 }}">
                                                            {{ $isF ? 'متاح' : 'مشغول' }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-2 small-muted">
                                        اقتراح: اضغط لتغيير حالة هذا السرير بسرعة.
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="mt-4 text-center">
                        <a href="{{ route('chambres.index', $chambre->auberge_id) }}" class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-arrow-right mr-1"></i> عودة
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('click', function(e){
    // toggle single lit
    const btn = e.target.closest('.js-toggle');
    if (btn) { handleToggle(btn); return; }

    // refresh date
    const refreshBtn = e.target.closest('#refreshDateBtn');
    if (refreshBtn) {
        const d = document.getElementById('dispoDate').value;
        const url = new URL(window.location.href);
        url.searchParams.set('date', d);
        window.location.href = url.toString();
        return;
    }

    // global block/unblock
    const blockBtn = e.target.closest('#blockRoomBtn');
    if (blockBtn) {
        Swal.fire({
            title: 'هل تريد فعلاً تبديل حالة كل الأسرّة؟',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then(res => {
            if (!res.isConfirmed) return;
            const dateValue = document.getElementById('dispoDate').value || new Date().toISOString().slice(0,10);
            const shouldOpen = {{ $globalDisponible ? 'false' : 'true' }}; // si global disponible => action = fermer (false)
            fetch("{{ route('chambres.disponibilite.block', $chambre->id_chambre_tente) }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ est_dispo: shouldOpen ? 1 : 0, date: dateValue })
            }).then(r => r.json()).then(data => {
                if (data.success) {
                    Swal.fire({ icon: 'success', title: data.message, timer:1200, showConfirmButton:false })
                        .then(()=> location.reload());
                } else {
                    Swal.fire({ icon: 'error', title: data.message || 'حدث خطأ' });
                }
            }).catch(err => {
                console.error(err);
                Swal.fire({ icon: 'error', title: 'خطأ في الاتصال بالخادم' });
            });
        });
        return;
    }
});

function handleToggle(btn) {
    const chambreId = btn.dataset.chambre;
    const litNum = btn.dataset.lit;
    const sexe = btn.dataset.sexe;
    const current = parseInt(btn.dataset.estado, 10);
    const newState = current ? 0 : 1;
    const dateValue = document.getElementById('dispoDate').value || new Date().toISOString().slice(0,10);

    Swal.fire({
        title: newState ? 'تأكيد تفعيل السرير؟' : 'تأكيد تعطيل السرير؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then(result => {
        if (!result.isConfirmed) return;
        fetch("{{ route('chambres.disponibilite.toggle') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                chambre_id: chambreId,
                lit_num: litNum,
                sexe: sexe,
                est_dispo: newState,
                date: dateValue
            })
        }).then(async r => {
            if (!r.ok) {
                const text = await r.text();
                console.error('Response not ok:', r.status, text);
                throw new Error('HTTP ' + r.status);
            }
            return r.json();
        }).then(data => {
            if (data.success) {
                btn.dataset.estado = newState;
                if (newState) {
                    btn.classList.remove('btn-outline-danger');
                    btn.classList.add('btn-outline-success');
                    btn.textContent = 'متاح';
                } else {
                    btn.classList.remove('btn-outline-success');
                    btn.classList.add('btn-outline-danger');
                    btn.textContent = 'مشغول';
                }
                Swal.fire({ icon: 'success', title: data.message, timer:1100, showConfirmButton:false });
            } else {
                Swal.fire({ icon: 'error', title: data.message || 'حدث خطأ' });
            }
        }).catch(err => {
            console.error(err);
            Swal.fire({ icon: 'error', title: 'خطأ في الاتصال بالخادم' });
        });
    });
}
</script>
@endsection
